/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CSVRecord;
import java.util.BitSet;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIIOSlotDataBean
implements PIDataBeanInterface {
    private static final String UNKNOWN_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "UNKNOWN");
    private static final String GENERIC_IOP = HSCResourceBundleUtil.getMessage("IOAdapterBundle", "200");
    private static final int SLOT_NOT_ASSIGNED = 65535;
    public static final int BUS_GROUPING_NOT_REQUIRED = 0;
    public static final int BUS_GROUPING_REQUIRED = 1;
    public static final int IOPINFO_IOP = 0;
    public static final int IOPINFO_CAPS_KNOWN = 1;
    public static final int IOPINFO_CAPS_STALE = 2;
    public static final int IOPINFO_CONSOLE_CAP = 3;
    public static final int IOPINFO_LOADSOURCE_CAP = 4;
    public static final int IOPINFO_LOADSOURCE_ATTCH = 5;
    public static final int IOPINFO_ALTLOADSOURCE_CAP = 6;
    public static final int IOPINFO_ALTLOADSOURCE_ATTCH = 7;
    public static final int IOPINFO_ECS_CAP = 8;
    public static final int IOPINFO_ECS_ATTCH = 9;
    public static final int IOPINFO_CONSOLE_TWINAX_CAP = 10;
    public static final int IOPINFO_CONSOLE_TWINAX_ATTCH = 11;
    public static final int IOPINFO_CONSOLE_DIRECT_CAP = 12;
    public static final int IOPINFO_CONSOLE_LAN_CAP = 13;
    public static final int NO_OS400_VPD = 0;
    public static final int HAS_OS400_VPD = 1;
    public static final int STALE_OS400_VPD = 2;
    public static final String KEY_DRAWER_LOC_CODE = "unit_phys_loc";
    public static final String KEY_DRAWER_ID = "unit_id";
    public static final String KEY_BUS_ID = "bus_id";
    public static final String KEY_SLOT_LPAR_ID = "lpar_id";
    public static final String KEY_SLOT_LPAR_NAME = "lpar_name";
    public static final String KEY_SLOT_IOPOOL = "slot_io_pool_id";
    public static final String KEY_SLOT_LOC = "phys_loc";
    public static final String KEY_SLOT_DESCRIPTION = "description";
    public static final String KEY_SLOT_PCI_VENDOR_ID = "pci_vendor_id";
    public static final String KEY_SLOT_PCI_DEVICE_ID = "pci_device_id";
    public static final String KEY_SLOT_PCI_SUBS_VENDOR_ID = "pci_subs_vendor_id";
    public static final String KEY_SLOT_PCI_SUBS_DEVICE_ID = "pci_subs_device_id";
    public static final String KEY_SLOT_PCI_CLASS = "pci_class";
    public static final String KEY_SLOT_PCI_CLASS_INFO = "pci_class_info";
    public static final String KEY_SLOT_PCI_REVISION_ID = "pci_revision_id";
    public static final String KEY_SLOT_BUS_GROUPING = "bus_grouping";
    public static final String KEY_SLOT_DRC_INDEX = "drc_index";
    public static final String KEY_SLOT_IOP_INFO = "iop_info";
    public static final String KEY_SLOT_IS_IOP = "iop";
    public static final String KEY_SLOT_IOPINFO_STALE = "iop_info_stale";
    public static final String KEY_SLOT_HAS_OS400_VPD = "has_os400_vpd";
    public static final String KEY_SLOT_STALE_OS400_VPD = "vpd_stale";
    public static final String KEY_SLOT_IOPINFO_CONSOLE_CAP = "console_capable";
    public static final String KEY_SLOT_IOPINFO_LOADSOURCE_CAP = "load_source_capable";
    public static final String KEY_SLOT_IOPINFO_LOADSOURCE_ATTCH = "load_source_attached";
    public static final String KEY_SLOT_IOPINFO_ALTLOADSOURCE_CAP = "alt_restart_device_capable";
    public static final String KEY_SLOT_IOPINFO_ALTLOADSOURCE_ATTCH = "alt_restart_device_attached";
    public static final String KEY_SLOT_IOPINFO_ECS_CAP = "op_console_capable";
    public static final String KEY_SLOT_IOPINFO_ECS_ATTCH = "op_console_attached";
    public static final String KEY_SLOT_IOPINFO_CONSOLE_TWINAX_CAP = "twinax_capable";
    public static final String KEY_SLOT_IOPINFO_CONSOLE_TWINAX_ATTCH = "twinax_attached";
    public static final String KEY_SLOT_IOPINFO_CONSOLE_DIRECT_CAP = "direct_console_capable";
    public static final String KEY_SLOT_IOPINFO_CONSOLE_LAN_CAP = "lan_console_capable";
    public static final String KEY_SLOT_PARENT_DRC_INDEX = "parent_slot_drc_index";
    public static final String KEY_SLOT_VPD_TYPE = "vpd_type";
    public static final String KEY_SLOT_VPD_MODEL = "vpd_model";
    public static final String KEY_SLOT_VPD_SERIAL = "vpd_serial_num";
    public static final String KEY_SLOT_FEATURE_CODES = "feature_codes";
    public static final String KEY_SLOT_DRC_NAME = "drc_name";
    public static final String KEY_SLOT_LOCK_OWNER_CLASS = "owner_class";
    public static final String KEY_SLOT_LOCK_OWNER_ID = "owner_id";
    public static final String[] ALL_KEYS = new String[]{"unit_id", "bus_id", "lpar_id", "lpar_name", "slot_io_pool_id", "phys_loc", "description", "pci_vendor_id", "pci_device_id", "pci_subs_vendor_id", "pci_subs_device_id", "pci_class", "pci_class_info", "pci_revision_id", "bus_grouping", "drc_index", "iop_info", "has_os400_vpd", "parent_slot_drc_index", "vpd_type", "vpd_model", "vpd_serial_num", "feature_codes", "drc_name", "owner_class", "owner_id"};
    private String m_drawerLocCode = null;
    private String m_drawerID = null;
    private String m_busID = null;
    private UnsignedInt16 m_lparID = null;
    private String m_lparName = null;
    private UnsignedInt16 m_ioPool = null;
    private String m_location = null;
    private UnsignedInt16 m_pciVendorId = null;
    private UnsignedInt16 m_pciDeviceId = null;
    private UnsignedInt16 m_pciSubsVendId = null;
    private UnsignedInt16 m_pciSubsDevId = null;
    private UnsignedInt16 m_pciClass = null;
    private String m_pciClassInfo = null;
    private UnsignedInt8 m_pciRevisionId = null;
    private UnsignedInt8 m_busGrouping = null;
    private String m_drcIndex = null;
    private BitSet m_iopInfo = null;
    private UnsignedInt8 m_hasOS400Vpd = null;
    private String m_parentDrcIndex = null;
    private String m_vpdType = null;
    private String m_vpdModel = null;
    private String m_vpdSerial = null;
    private String m_ccinDescription = null;
    private UnsignedInt16[] m_featureCodes = null;
    private String[] m_featureCodeDescriptions = null;
    private String m_drcName = null;
    private UnsignedInt8 m_ownerClass = null;
    private UnsignedInt16 m_ownerId = null;

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public boolean busIDMatch(String string) {
        if (null != this.m_busID) {
            return this.m_busID.equals(string);
        }
        return false;
    }

    public String getDrawerLocCode() {
        return this.m_drawerLocCode;
    }

    public UnsignedInt8 getBusGrouping() {
        return this.m_busGrouping;
    }

    public String getBusID() {
        return this.m_busID;
    }

    public UnsignedInt16 getOwner() {
        return this.m_lparID;
    }

    public String getOwnerName() {
        return this.m_lparName;
    }

    public String getDrawerID() {
        return this.m_drawerID;
    }

    public String getDrcIndex() {
        return this.m_drcIndex;
    }

    public UnsignedInt8 getHasOS400Vpd() {
        return this.m_hasOS400Vpd;
    }

    public BitSet getIopInfo() {
        return this.m_iopInfo;
    }

    public UnsignedInt16 getIoPool() {
        return this.m_ioPool;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getParentDrcIndex() {
        return this.m_parentDrcIndex;
    }

    public UnsignedInt16 getPciClass() {
        return this.m_pciClass;
    }

    public String getPciClassInfo() {
        if (this.m_pciClassInfo == null) {
            this.m_pciClassInfo = "";
        }
        return this.m_pciClassInfo;
    }

    public UnsignedInt16 getPciDeviceId() {
        return this.m_pciDeviceId;
    }

    public UnsignedInt8 getPciRevisionId() {
        return this.m_pciRevisionId;
    }

    public UnsignedInt16 getPciSubsDevId() {
        return this.m_pciSubsDevId;
    }

    public UnsignedInt16 getPciSubsVendId() {
        return this.m_pciSubsVendId;
    }

    public UnsignedInt16 getPciVendorId() {
        return this.m_pciVendorId;
    }

    public String getVpdModel() {
        return this.m_vpdModel;
    }

    public String getVpdSerial() {
        return this.m_vpdSerial;
    }

    public String getVpdType() {
        return this.m_vpdType;
    }

    public UnsignedInt16[] getFeatureCodes() {
        return this.m_featureCodes;
    }

    public String getDrcName() {
        return this.m_drcName;
    }

    public UnsignedInt8 getOwnerClass() {
        return this.m_ownerClass;
    }

    public UnsignedInt16 getOwnerId() {
        return this.m_ownerId;
    }

    public boolean isIOP() {
        return this.m_iopInfo != null && this.m_iopInfo.get(0);
    }

    public void setDrawerLocCode(String string) {
        this.m_drawerLocCode = string;
    }

    public void setBusGrouping(UnsignedInt8 unsignedInt8) {
        this.m_busGrouping = unsignedInt8;
    }

    public void setBusID(String string) {
        this.m_busID = string;
    }

    public void setOwner(UnsignedInt16 unsignedInt16) {
        this.m_lparID = unsignedInt16;
    }

    public void setOwnerName(String string) {
        this.m_lparName = string;
    }

    public void setDrawerID(String string) {
        this.m_drawerID = string;
    }

    public void setDrcIndex(String string) {
        this.m_drcIndex = string;
    }

    public void setHasOS400Vpd(UnsignedInt8 unsignedInt8) {
        this.m_hasOS400Vpd = unsignedInt8;
    }

    public void setIopInfo(BitSet bitSet) {
        this.m_iopInfo = bitSet;
    }

    public void setIoPool(UnsignedInt16 unsignedInt16) {
        this.m_ioPool = unsignedInt16;
    }

    public void setLocation(String string) {
        this.m_location = string;
    }

    public void setParentDrcIndex(String string) {
        this.m_parentDrcIndex = string;
    }

    public void setPciClass(UnsignedInt16 unsignedInt16) {
        this.m_pciClass = unsignedInt16;
    }

    public void setPciClassInfo(String string) {
        this.m_pciClassInfo = string;
    }

    public void setPciDeviceId(UnsignedInt16 unsignedInt16) {
        this.m_pciDeviceId = unsignedInt16;
    }

    public void setPciRevisionId(UnsignedInt8 unsignedInt8) {
        this.m_pciRevisionId = unsignedInt8;
    }

    public void setPciSubsDevId(UnsignedInt16 unsignedInt16) {
        this.m_pciSubsDevId = unsignedInt16;
    }

    public void setPciSubsVendId(UnsignedInt16 unsignedInt16) {
        this.m_pciSubsVendId = unsignedInt16;
    }

    public void setPciVendorId(UnsignedInt16 unsignedInt16) {
        this.m_pciVendorId = unsignedInt16;
    }

    public void setVpdModel(String string) {
        this.m_vpdModel = string;
    }

    public void setVpdSerial(String string) {
        this.m_vpdSerial = string;
    }

    public void setVpdType(String string) {
        this.m_vpdType = string;
    }

    public void setFeatureCodes(UnsignedInt16[] unsignedInt16Array) {
        this.m_featureCodes = unsignedInt16Array;
    }

    public void setDrcName(String string) {
        this.m_drcName = string;
    }

    public void setOwnerClass(UnsignedInt8 unsignedInt8) {
        this.m_ownerClass = unsignedInt8;
    }

    public void setOwnerId(UnsignedInt16 unsignedInt16) {
        this.m_ownerId = unsignedInt16;
    }

    public String getCcinDescription() {
        return this.m_ccinDescription;
    }

    public String[] getFeatureCodeDescriptions() {
        return this.m_featureCodeDescriptions;
    }

    public void setCcinDescription(String string) {
        this.m_ccinDescription = string;
    }

    public void setFeatureCodeDescriptions(String[] stringArray) {
        this.m_featureCodeDescriptions = stringArray;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Object object;
            String string2 = stringArray[i];
            if (KEY_DRAWER_LOC_CODE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_drawerLocCode, bl);
                continue;
            }
            if (KEY_BUS_ID.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_busID, bl);
                continue;
            }
            if (KEY_SLOT_LPAR_ID.equals(string2)) {
                if (this.m_lparID != null && this.m_lparID.intValue() != 65535) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_lparID, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "none", bl);
                continue;
            }
            if (KEY_SLOT_LPAR_NAME.equals(string2)) {
                if (bl && (this.m_lparID == null || this.m_lparID.intValue() == 65535)) continue;
                CSVRecord.append(cSVRecord, string2, this.m_lparName, bl);
                continue;
            }
            if (KEY_SLOT_IOPOOL.equals(string2)) {
                if (this.m_ioPool == null || this.m_ioPool.intValue() == 65535) {
                    CSVRecord.append(cSVRecord, string2, "none", bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (Number)this.m_ioPool, bl);
                continue;
            }
            if (KEY_SLOT_LOC.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_location, bl);
                continue;
            }
            if (KEY_SLOT_DESCRIPTION.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getBestKnownDescription(), bl);
                continue;
            }
            if (KEY_SLOT_PCI_VENDOR_ID.equals(string2)) {
                if (this.m_pciVendorId != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString(this.m_pciVendorId), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_SLOT_PCI_DEVICE_ID.equals(string2)) {
                if (this.m_pciDeviceId != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString(this.m_pciDeviceId), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_SLOT_PCI_SUBS_VENDOR_ID.equals(string2)) {
                if (this.m_pciSubsVendId != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString(this.m_pciSubsVendId), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_SLOT_PCI_SUBS_DEVICE_ID.equals(string2)) {
                if (this.m_pciSubsDevId != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString(this.m_pciSubsDevId), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_SLOT_PCI_CLASS.equals(string2)) {
                if (this.m_pciClass != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString(this.m_pciClass), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_SLOT_PCI_REVISION_ID.equals(string2)) {
                if (this.m_pciRevisionId != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString((Number)this.m_pciRevisionId, 2), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (KEY_SLOT_BUS_GROUPING.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_busGrouping, bl);
                continue;
            }
            if (KEY_SLOT_DRC_INDEX.equals(string2)) {
                if (this.m_drcIndex != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString((Number)new UnsignedInt32(this.m_drcIndex), 8), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, this.m_drcIndex, bl);
                continue;
            }
            if (KEY_SLOT_IOP_INFO.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_iopInfo.toString(), bl);
                continue;
            }
            if (KEY_SLOT_STALE_OS400_VPD.equals(string2)) {
                object = null;
                n = 0;
                if (this.m_hasOS400Vpd != null) {
                    n = this.m_hasOS400Vpd.intValue();
                }
                if (n == 1) {
                    object = "0";
                } else if (n == 2) {
                    object = "1";
                }
                if (bl && n == 0) continue;
                CSVRecord.append(cSVRecord, string2, (String)object, bl);
                continue;
            }
            if (KEY_SLOT_PARENT_DRC_INDEX.equals(string2)) {
                object = null;
                if (this.m_parentDrcIndex != null) {
                    object = new UnsignedInt32(this.m_parentDrcIndex);
                }
                if (object != null && object.intValue() != 0) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString((Number)object, 8), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "none", bl);
                continue;
            }
            if (KEY_SLOT_VPD_TYPE.equals(string2)) {
                if (bl && (this.m_hasOS400Vpd == null || this.m_hasOS400Vpd.intValue() == 0)) continue;
                CSVRecord.append(cSVRecord, string2, this.m_vpdType, bl);
                continue;
            }
            if (KEY_SLOT_VPD_MODEL.equals(string2)) {
                if (bl && (this.m_hasOS400Vpd == null || this.m_hasOS400Vpd.intValue() == 0)) continue;
                CSVRecord.append(cSVRecord, string2, this.m_vpdModel, bl);
                continue;
            }
            if (KEY_SLOT_VPD_SERIAL.equals(string2)) {
                if (bl && (this.m_hasOS400Vpd == null || this.m_hasOS400Vpd.intValue() == 0)) continue;
                CSVRecord.append(cSVRecord, string2, this.m_vpdSerial, bl);
                continue;
            }
            if (KEY_SLOT_DRC_NAME.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_drcName, bl);
                continue;
            }
            if (KEY_SLOT_FEATURE_CODES.equals(string2)) {
                object = new CSVRecord();
                if (this.m_featureCodes != null) {
                    for (n = 0; n < this.m_featureCodes.length; ++n) {
                        ((CSVRecord)object).add(this.m_featureCodes[n]);
                    }
                    if (((CSVRecord)object).size() != 0) {
                        CSVRecord.append(cSVRecord, string2, ((CSVRecord)object).toString(), bl);
                        continue;
                    }
                    CSVRecord.append(cSVRecord, string2, "none", bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "none", bl);
                continue;
            }
            if (KEY_SLOT_IS_IOP.equals(string2)) {
                object = null;
                if (this.m_iopInfo != null) {
                    object = this.m_iopInfo.get(0) ? "1" : "0";
                }
                CSVRecord.append(cSVRecord, string2, (String)object, bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_STALE.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(2), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_CONSOLE_CAP.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(3), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_LOADSOURCE_CAP.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(4), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_LOADSOURCE_ATTCH.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(5), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_ALTLOADSOURCE_CAP.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(6), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_ALTLOADSOURCE_ATTCH.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(7), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_ECS_CAP.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(8), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_ECS_ATTCH.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(9), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_CONSOLE_TWINAX_CAP.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(10), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_CONSOLE_TWINAX_ATTCH.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(11), bl);
                continue;
            }
            if (KEY_SLOT_IOPINFO_CONSOLE_DIRECT_CAP.equals(string2)) {
                if (bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
                CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(12), bl);
                continue;
            }
            if (!KEY_SLOT_IOPINFO_CONSOLE_LAN_CAP.equals(string2) || bl && (this.m_iopInfo == null || !this.isIOP() || !this.m_iopInfo.get(1))) continue;
            CSVRecord.append(cSVRecord, string2, this.getIOPInfoValue(13), bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    public String getBestKnownDescription() {
        String string = null;
        string = this.m_ccinDescription != null && !this.m_ccinDescription.equals(UNKNOWN_ADAPTER) ? this.m_ccinDescription : (this.m_featureCodeDescriptions != null && this.m_featureCodeDescriptions.length > 0 && this.m_featureCodeDescriptions[0] != null && !UNKNOWN_ADAPTER.equals(this.m_featureCodeDescriptions[0]) ? this.m_featureCodeDescriptions[0] : (this.isIOP() ? GENERIC_IOP : (this.m_pciClassInfo != null && !this.m_pciClassInfo.equals(UNKNOWN_ADAPTER) ? this.m_pciClassInfo : UNKNOWN_ADAPTER)));
        if (this.m_featureCodes != null && this.m_featureCodes.length > 0 && this.m_featureCodes[0] != null && this.m_featureCodes[0].intValue() == 0 && this.isIOP()) {
            string = GENERIC_IOP;
        }
        return string;
    }

    private String getIOPInfoValue(int n) {
        String string = null;
        if (this.m_iopInfo != null && this.m_iopInfo.get(0) && this.m_iopInfo.get(1)) {
            string = this.m_iopInfo.get(n) ? "1" : "0";
        }
        return string;
    }
}

